//
// $Id: Clip.java,v 1.1 1998/11/05 02:21:24 min Exp min $
//

import java.applet.*;
import java.awt.*;
import myutil.*;





public class Clip extends Applet
{
  private TextField header = new TextField("Cohen-Sutherland Line Clipping");
  private Font my_font = new Font("Helvetica", Font.BOLD, 12);

  private ClipCanvas my_canvas = new ClipCanvas();

  private Panel button_panel = new Panel();
  private Button random_button = new Button("Random line");
  private Button clip_button = new Button("   Clip   ");

  // Textfields
  private static final String code0_text = "Point 0 region code:   ";
  private static final String code1_text = "Point 1 region code:   ";
  private static final String and_text = "AND of region codes: ";
  private static final String status_text = "Clipping status: ";
  private TextField code0 = new TextField(code0_text);
  private TextField code1 = new TextField(code1_text);
  private TextField and = new TextField(and_text);
  private TextField status_line = new TextField(status_text);

  private GridBagLayout my_layout = new GridBagLayout();



  public Clip()
  {
    // set font & editable of the textfields
    header.setFont(my_font);
    header.setEditable(false);
    code0.setFont(my_font);
    code0.setEditable(false);
    code1.setFont(my_font);
    code1.setEditable(false);
    and.setFont(my_font);
    and.setEditable(false);
    status_line.setFont(my_font);
    status_line.setEditable(false);

    random_button.setFont(my_font);
    clip_button.setFont(my_font);
    create_layout();
    my_canvas.set_parent(this);
    paint();
  }  // constructor



  public String getAppletInfo()
  {
    return "Cohen-Sutherland Clipping v1.2 by Patrick Min, min@cs.princeton.edu\n$Id: Clip.java,v 1.1 1998/11/05 02:21:24 min Exp min $";
  }  // getAppletInfo



  private void create_layout()
  {
    this.setLayout(my_layout);
    Layout.constrain(this, header, 0, 0, 3, 1,
		     GridBagConstraints.NONE, GridBagConstraints.CENTER,
		     1.0, 0.1, 1, 1, 1, 1);
    Layout.constrain(this, my_canvas, 0, 1, 3, 3,
		     GridBagConstraints.BOTH, GridBagConstraints.CENTER,
		     1.0, 1.0, 2, 2, 2, 2);

    button_panel.setLayout(my_layout);
    Layout.constrain_button(button_panel, random_button, 1, 0);
    Layout.constrain_button(button_panel, clip_button, 1, 1);
    Layout.constrain(button_panel, code0, 0, 0, 1, 1,
		     GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER,
		     0.1, 0.1, 1, 1, 1, 1);
    Layout.constrain(button_panel, code1, 0, 1, 1, 1,
		     GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER,
		     0.1, 0.1, 1, 1, 1, 1);
    Layout.constrain(button_panel, and, 0, 2, 1, 1,
		     GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER,
		     0.1, 0.1, 1, 1, 1, 1);
    Layout.constrain(button_panel, status_line, 1, 2, 1, 1,
		     GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER,
		     0.1, 0.1, 1, 1, 1, 1);

    Layout.constrain(this, button_panel, 0, 4, 3, 1,
		     GridBagConstraints.BOTH, GridBagConstraints.CENTER,
		     1.0, 0.2, 2, 2, 2, 2);
		     
  }  // create_layout



  public boolean action(Event e, Object arg)
  {
    if (e.target == random_button) {
      my_canvas.random_line();
      paint();
      return true;
    }
    else if (e.target == clip_button) {
      my_canvas.clip_line();
      paint();
      my_canvas.paint();
      return true;
    }
    return false;
  }  // action



  public void paint()
  {
    code0.setText(code0_text + my_canvas.get_regioncode(0));
    code1.setText(code1_text + my_canvas.get_regioncode(1));
    and.setText(and_text + my_canvas.get_and_code(my_canvas.get_regioncode(0),
						  my_canvas.get_regioncode(1)));
    
    StringBuffer status = new StringBuffer(status_text);
    int status_code = my_canvas.get_status();
    
    switch (status_code) {
    case ClipCanvas.UNKNOWN:
      status.append("Unknown (press 'Clip')"); break;
    case ClipCanvas.NO_LINE: 
      status.append("No line present"); break;
    case ClipCanvas.TRIVIAL_ACCEPT: 
      status.append("Line trivially accepted (both codes are 0000)"); break;
    case ClipCanvas.OUTSIDE:
      status.append("Line completely outside (AND does not equal 0000)"); 
      break;
    case ClipCanvas.CLIPPED_LEFT:
      status.append("Clipped to the LEFT boundary");
      break;
    case ClipCanvas.CLIPPED_RIGHT:
      status.append("Clipped to the RIGHT boundary");
      break;
    case ClipCanvas.CLIPPED_BOTTOM:
      status.append("Clipped to the BOTTOM boundary");
      break;
    case ClipCanvas.CLIPPED_TOP:
      status.append("Clipped to the TOP boundary");
      break;
    }  // switch
    status_line.setText(status.toString());

  }  // paint



}  // class Clip


