//
// $Id: ClipCanvas.java,v 1.1 1998/11/05 02:21:24 min Exp min $
//

import java.awt.*;
import java.lang.*;
import java.util.*;



public class ClipCanvas extends Canvas
{
  private Image offscreen;
  private int image_width;
  private int image_height;
  private int left, right, top, bottom;

  private int x[] = new int[2];
  private int y[] = new int[2];
  private int points_present;
  private int status;

  public static final int UNKNOWN = -1;
  public static final int NO_LINE = 0;
  public static final int TRIVIAL_ACCEPT = 1;
  public static final int OUTSIDE = 2;
  public static final int CLIPPED_LEFT = 3;
  public static final int CLIPPED_RIGHT = 4;
  public static final int CLIPPED_TOP = 5;
  public static final int CLIPPED_BOTTOM = 6;

  private Clip my_parent;



  public ClipCanvas()
  {
    points_present = 0;
    status = ClipCanvas.NO_LINE;
  }  // constructor



  public Dimension preferredSize()
  {
    return new Dimension(400, 300);
  }  // preferredSize



  public Dimension minimumSize()
  {
    return new Dimension(200, 150);
  }  // minimumSize



  public void set_parent(Clip parent)
  {
    my_parent = parent;
  }  // set_parent



  public void paint()
  {
    Dimension d = this.size();
    if ((offscreen == null) || (d.width != image_width) ||
      (d.height != image_height))
    {
      if ((d.width < 1) || (d.height < 1)) return;
      offscreen = this.createImage(d.width, d.height);
      image_width = d.width;
      image_height = d.height;
    }  // if, window size has changed

    Graphics off_g = offscreen.getGraphics();
    clear(off_g);
    draw_window(off_g);
    draw_points(off_g);
    Graphics my_g = this.getGraphics();
    my_g.drawImage(offscreen, 0, 0, this);
  }  // paint
  


  public void draw_points(Graphics g)
  {
    if (points_present > 0) {
      if (points_present == 2) {  // 2 points found
			g.setColor(Color.green);
			g.drawLine(x[0], y[0], x[1], y[1]);
			g.setColor(Color.blue);
			g.fillOval(x[1] - 3, y[1] - 3, 6, 6);
			g.setColor(Color.white);
			g.drawString("1", x[1] + 4, y[1] - 4);
      }
		// points < 2, draw point only
      g.setColor(Color.blue); 
      g.fillOval(x[0] - 3, y[0] - 3, 6, 6);
      g.setColor(Color.white);
      g.drawString("0", x[0] + 4, y[0] - 4);
    }
  }  // draw_points



  public void paint(Graphics g)
  {
    paint();
  }  // official paint



  public boolean mouseDown(Event e, int mouse_x, int mouse_y)
  {
    switch (points_present) {
    case 0: x[0] = mouse_x; // no points
      y[0] = mouse_y;
      points_present++; // increment number of points count
      break;
    case 1: x[1] = mouse_x;  // 1 point
      y[1] = mouse_y;
      points_present++;
      break;
    case 2: x[0] = mouse_x;  // 2 points
      y[0] = mouse_y;
      points_present--;
      break;
    }
    paint();
    if (points_present < 2) status = ClipCanvas.NO_LINE;
    else status = ClipCanvas.UNKNOWN;
    my_parent.paint(); // update the parent components, to inform 
	                    // user of changes
    return true;
  }  // mouseDown



  public String get_regioncode(int index)
  {
    if ((index + 1) > points_present) return "n/a";
    StringBuffer code = new StringBuffer("0000");

    if (x[index] < left) code.setCharAt(3, '1');
    else
      if (x[index] > right) code.setCharAt(2, '1');
    if (y[index] > bottom)  code.setCharAt(1, '1');
    else
      if (y[index] < top) code.setCharAt(0, '1');

    return (code.toString());
  }  // get_regioncode


    
  public String get_and_code(String code0, String code1)
  {
    if (points_present != 2) return "n/a";

    StringBuffer and_code = new StringBuffer("0000");

    for(int i=0; i<4; i++) {
      if ((code0.charAt(i) == '1') && (code1.charAt(i) == '1'))
			and_code.setCharAt(i, '1');
    }
    return (and_code.toString());
  }  // get_and_code



  private void clear(Graphics g)
  {
    g.setColor(Color.black);
    g.fillRect(0, 0, image_width, image_height);
  }  // clear
  


  private void draw_window(Graphics g)
  {
    int half_width = image_width/2;
    int half_height = image_height/2;

    left = image_width/4; // left clipping plane
    top = image_height/4; // top  clipping plane

    g.setColor(Color.white);
    g.drawRect(left, top, half_width, half_height);

    right = left + half_width;  // right clipping plane
    bottom = top + half_height; // bottom clipping plane

    g.setColor(Color.lightGray);
    draw_stippled_line(g, 0, top, left, top);
    draw_stippled_line(g, 0, bottom, left, bottom);
    draw_stippled_line(g, right, top, image_width, top);
    draw_stippled_line(g, right, bottom, image_width, bottom);

    draw_stippled_line(g, left, 0, left, top);
    draw_stippled_line(g, right, 0, right, top);
    draw_stippled_line(g, left, bottom, left, image_height);
    draw_stippled_line(g, right, bottom, right, image_height);

    Font my_font = new Font("courier", Font.BOLD, 12);
    g.setFont(my_font);
    g.setColor(Color.darkGray);
    g.drawString("0000", half_width, half_height);
    g.drawString("1001", left/2, top/2);
    g.drawString("1000", half_width, top/2);
    g.drawString("1010", image_width - left/2, top/2);
    g.drawString("0001", left/2, half_height);
    g.drawString("0010", image_width - left/2, half_height);
    g.drawString("0101", left/2, image_height - top/2);
    g.drawString("0100", half_width, image_height - top/2);
    g.drawString("0110", image_width - left/2, image_height - top/2);

  }  // draw_window



  private void draw_stippled_line(Graphics g, int x1, int y1, int x2, int y2)
  {
    double width = x2 - x1;
    double height = y2 - y1;
    double length = Math.sqrt(width * width + height * height);
    int nr_steps = (int) Math.round(length/5);
    double delta_x = (double) (x2 - x1)/(double) nr_steps;
    double delta_y = (double) (y2 - y1)/(double) nr_steps;

    for(int i=0; i<nr_steps; i++) {
      int new_x1 = x1 + (int) Math.round(i * delta_x);
      int new_y1 = y1 + (int) Math.round(i * delta_y);
      int new_x2 = x1 + (int) Math.round((i + 0.4) * delta_x);
      int new_y2 = y1 + (int) Math.round((i + 0.4) * delta_y);

      g.drawLine(new_x1, new_y1, new_x2, new_y2);
    }
  }  // draw_stippled_line



  public void random_line()
  {
    Random r = new Random();

    points_present = 2;
    x[0] = Math.abs (r.nextInt() % image_width);
    x[1] = Math.abs (r.nextInt() % image_width);
    y[0] = Math.abs (r.nextInt() % image_height);
    y[1] = Math.abs (r.nextInt() % image_height);
    status = ClipCanvas.UNKNOWN;
    paint();
  }  // random_line



  public void clip_line()
  {
    if (points_present != 2) {
      status = ClipCanvas.NO_LINE;
      return;
    }

    String codes[] = new String[2];

	 // get the regioncode for each point
    codes[0] = new String (get_regioncode(0));
    codes[1] = new String (get_regioncode(1));

    boolean done = false;
    int point_to_clip = 0;  // start with point 0
    
    while (!done) {
      
      if ((codes[0].equals("0000")) && (codes[1].equals("0000"))) {
			status = ClipCanvas.TRIVIAL_ACCEPT;
			done = true;
			continue;
      }
      
		// check for result of "0000" when anding end codes
      if (!(get_and_code(codes[0], codes[1]).equals("0000"))) {
			status = ClipCanvas.OUTSIDE;
			done = true;
			continue;
      }

      double delta_x = x[1] - x[0];
      double delta_y = y[1] - y[0];
      double slope = delta_y/delta_x;

      Graphics g = this.getGraphics();
      g.setColor(Color.red);

      int x_i = 0, y_i = 0;
      
      if (codes[point_to_clip].charAt(3) == '1') {   // to the left 
	// compute intersection
	x_i = left;
	y_i = y[point_to_clip] + (int) Math.round(slope * (left - x[point_to_clip]));
	status = ClipCanvas.CLIPPED_LEFT;
      }  // left
      else if (codes[point_to_clip].charAt(2) == '1') {  // to the right
	x_i = right;
	y_i = y[point_to_clip] + (int) Math.round(slope * (right - x[point_to_clip]));
	status = ClipCanvas.CLIPPED_RIGHT;
      }  // right
      else if (codes[point_to_clip].charAt(1) == '1') {  // below
	x_i = x[point_to_clip] + (int) Math.round((bottom - y[point_to_clip])/slope);
	y_i = bottom;
	status = ClipCanvas.CLIPPED_BOTTOM;
      }
      else if (codes[point_to_clip].charAt(0) == '1') {  // top
	x_i = x[point_to_clip] + (int) Math.round((top - y[point_to_clip])/slope);
	y_i = top;
	status = ClipCanvas.CLIPPED_TOP;
      }
      else {
	point_to_clip = 1 - point_to_clip;
	continue;
      }
      
      // draw stippled line
      draw_stippled_line(g, x[point_to_clip], y[point_to_clip], x_i, y_i);
      // change point i
      x[point_to_clip] = x_i;
      y[point_to_clip] = y_i;
      draw_points(g);
      // recompute region code
      codes[point_to_clip] = new String(get_regioncode(point_to_clip));
      // tell user what happened
      my_parent.paint();
      // wait a while
      try { Thread.sleep(2500); }
      catch (InterruptedException e) {}

      point_to_clip = 1 - point_to_clip;  // switch to the other point
      
    }  // while

  }  // clip_line



  public int get_status()
  {
    return status;
  }  // get_status


}  // ClipCanvas



